# 機能設計書 1-テンソル操作（Tensor Operations）

## 概要

本ドキュメントは、TensorFlowのコアフレームワークにおけるテンソル操作（Tensor Operations）機能の設計を記述する。多次元配列（テンソル）の生成・変形・スライス・結合・分割などの基本操作を提供する中核機能である。

### 本機能の処理概要

テンソル操作は、TensorFlowにおけるすべての計算の基盤となるデータ構造操作を提供する。テンソル（多次元配列）に対して形状変換、要素アクセス、結合・分割、パディング、ブロードキャストなどの操作を実行し、機械学習パイプラインのデータ前処理やモデル構築に必要な低レベル配列操作を可能にする。

**業務上の目的・背景**：機械学習モデルの構築・訓練・推論において、データは多次元配列（テンソル）として表現される。入力データの形状変換、特徴量の結合、バッチ処理のためのスタッキングなど、あらゆる場面でテンソルの形状操作が必要となる。本機能はこれらの基本操作を効率的かつ型安全に提供することで、フレームワーク全体の基盤を形成する。

**機能の利用シーン**：(1) 入力データのバッチ化（reshape, stack）、(2) CNNの入力テンソル形状変換（transpose, expand_dims）、(3) 注意機構でのテンソル結合・分割（concat, split）、(4) 可変長シーケンスのパディング（pad）、(5) 条件付きデータ選択（where, boolean_mask）、(6) テンソルの初期化（zeros, ones, fill）。

**主要な処理内容**：
1. テンソル生成: zeros, ones, fill, constant によるテンソルの初期化
2. 形状操作: reshape, transpose, expand_dims, squeeze による形状変換
3. スライス・インデックス: slice, strided_slice, gather, gather_nd による部分取得
4. 結合・分割: concat, stack, unstack, split によるテンソルの結合と分割
5. パディング: pad による次元ごとのパディング付加
6. 条件操作: where, boolean_mask による条件付き要素選択
7. 形状情報取得: shape, rank, size によるテンソルメタデータの取得

**関連システム・外部連携**：本機能はTensorFlowの内部C++カーネル（gen_array_ops）を通じてCPU/GPU上で実行される。DTensor APIとの統合によりデバイスメッシュ上での分散テンソル操作も可能である。NumPyとの相互変換インターフェースも提供する。

**権限による制御**：特になし。すべてのユーザが利用可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はコアAPIのため直接的な画面関連はなし |

## 機能種別

計算処理（テンソル操作・変換処理）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| tensor / input | tf.Tensor | Yes | 操作対象のテンソル | 有効なテンソルであること |
| shape | list[int] / tf.TensorShape | 操作による | 目標形状 | 要素数が元テンソルと一致すること（reshapeの場合） |
| axis | int / list[int] | 操作による | 操作対象の軸 | テンソルのランク範囲内であること |
| name | string | No | 操作名 | - |
| dtype | tf.DType | No | データ型指定 | サポートされるデータ型であること |

### 入力データソース

Python API呼び出し時の引数として入力される。テンソルはEager実行モードでは即座にNumPy配列相当のデータを保持し、Graph実行モードではシンボリックなハンドルとして扱われる。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| result | tf.Tensor | 操作結果のテンソル |
| shape_info | tf.TensorShape | テンソルの形状情報（shape/rank/size操作時） |

### 出力先

呼び出し元のPythonコードに返却される。計算グラフに組み込まれた場合はグラフノードとして保持される。

## 処理フロー

### 処理シーケンス

```
1. Python API呼び出し受付
   └─ dispatch機構によるオーバーライド確認（@dispatch.add_dispatch_support）
2. 入力テンソルの変換・検証
   └─ ops.convert_to_tensor()による型変換、DTensor APIの確認
3. C++カーネルへのディスパッチ
   └─ gen_array_ops経由でC++実装を呼び出し
4. 形状推論（Shape Inference）
   └─ InferenceContextによる出力形状の自動計算
5. カーネル実行
   └─ CPU/GPU上で実際の計算を実行
6. 結果テンソルの返却
   └─ tf.Tensor オブジェクトとして返却
```

### フローチャート

```mermaid
flowchart TD
    A[Python API呼び出し] --> B{dispatch対象か?}
    B -->|Yes| C[カスタムdispatch実行]
    B -->|No| D[入力テンソル変換・検証]
    C --> D
    D --> E{DTensor入力か?}
    E -->|Yes| F[DTensor API経由で実行]
    E -->|No| G{Eager実行モード?}
    G -->|Yes| H[C++カーネルを直接実行]
    G -->|No| I[計算グラフにノード追加]
    F --> J[結果テンソル返却]
    H --> J
    I --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 要素数保存 | reshape時に入出力テンソルの総要素数は一致しなければならない | reshape操作時 |
| BR-02 | ブロードキャスト規則 | NumPy互換のブロードキャスト規則に従う | バイナリ演算時 |
| BR-03 | 軸範囲制約 | 指定軸はテンソルのランク範囲内でなければならない（負数インデックス可） | axis引数を持つ操作 |
| BR-04 | 型互換性 | concat等の結合操作では全入力テンソルが同一データ型でなければならない | 結合操作時 |

### 計算ロジック

- reshape: 入力テンソルのメモリレイアウトを変更せず、形状メタデータのみ変更（ゼロコピー）
- transpose: 軸の並べ替えに応じてストライドを再計算
- pad: 指定されたパディング値を各次元の前後に追加
- gather: indices で指定された位置の要素をaxis次元に沿って収集

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作は発生しない |

### テーブル別操作詳細

該当なし。本機能はインメモリのテンソル演算のみを行う。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidArgumentError | バリデーションエラー | reshapeで要素数が不一致 | 入力形状と目標形状の要素数を一致させる |
| InvalidArgumentError | バリデーションエラー | axisがランク範囲外 | 有効な軸インデックスを指定する |
| TypeError | 型エラー | 非テンソル入力 | tf.convert_to_tensorで変換可能な入力を使用する |
| ValueError | 形状エラー | concatで形状が不一致（結合軸以外） | 結合軸以外の次元を揃える |

### リトライ仕様

該当なし。テンソル操作は決定的であり、リトライは不要。

## トランザクション仕様

該当なし。テンソル操作はステートレスな計算であり、トランザクション管理は不要。

## パフォーマンス要件

- reshape操作はメモリコピーを発生させず、O(1)で完了すること
- GPU上での実行時はデバイスメモリ上で直接操作し、ホスト-デバイス間転送を最小化すること
- 大規模テンソルのconcat/split操作は並列実行により線形スケールすること

## セキュリティ考慮事項

- gather/gather_nd操作でのインデックス範囲外アクセスに対する保護
- 大規模テンソル生成によるメモリ枯渇への対策（OOMエラーの適切なハンドリング）

## 備考

- gen_array_opsモジュールはC++のop定義からPython bindingが自動生成される
- newaxis定数（None）はNumPy互換のスライス操作に使用される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テンソル操作の基盤となるTensorクラスとTensorShape、DTypeの定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | tensor.py | `tensorflow/python/framework/tensor.py` | tf.Tensor クラスの定義、shape/dtype プロパティ |
| 1-2 | tensor_shape.py | `tensorflow/python/framework/tensor_shape.py` | TensorShape クラス、次元情報の管理 |
| 1-3 | dtypes.py | `tensorflow/python/framework/dtypes.py` | DType列挙型、サポートされるデータ型一覧 |

**読解のコツ**: TensorFlowのテンソルはEagerモードとGraphモードで異なる振る舞いをする。EagerTensorは即座に値を保持し、GraphモードではSymbolicTensorとして形状情報のみを保持する。

#### Step 2: エントリーポイントを理解する

Python APIのエントリーポイントであるarray_ops.pyの主要関数を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | array_ops.py | `tensorflow/python/ops/array_ops.py` | tf.reshape, tf.concat, tf.stack等の公開API |

**主要処理フロー**:
1. **65行目**: `reshape` 関数 - テンソルの形状変換エントリーポイント
2. **206行目**: `fill` 関数 - 指定値でテンソルを生成
3. **255行目**: `identity` 関数 - テンソルのコピー
4. **321行目**: `expand_dims` 関数 - 次元追加
5. **600行目**: `shape_v2` 関数 - 形状情報取得
6. **942行目**: `slice` 関数 - テンソルのスライス
7. **1352行目**: `concat` 関数 - テンソルの結合
8. **1447行目**: `boolean_mask` 関数 - 条件付きマスキング
9. **1746行目**: `split` 関数 - テンソルの分割
10. **1828行目**: `transpose_v2` 関数 - 転置操作
11. **2602行目**: `zeros` 関数 - ゼロテンソル生成
12. **4237行目**: `squeeze` 関数 - サイズ1の次元削除
13. **4366行目**: `where` 関数 - 条件選択
14. **4788行目**: `gather` 関数 - インデックス指定による要素収集

#### Step 3: C++オペレーション定義を理解する

C++側のop登録とshape inference関数を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | array_ops.cc | `tensorflow/core/ops/array_ops.cc` | REGISTER_OPマクロによるop定義、ShapeFn |

**主要処理フロー**:
- **46-56行目**: `GetAxisForPackAndUnpack` - Pack/Unpack操作の軸検証
- **68-84行目**: `PadKnown` - パディングの形状推論
- **86-100行目**: `PadShapeFn` - Pad操作の形状推論関数
- **289行目**: `ParallelConcat` op登録
- **334行目**: `Pack` op登録
- **524行目**: `Concat` op登録
- **579行目**: `Split` op登録
- **721行目**: `Const` op登録
- **780行目**: `ZerosLike` op登録

#### Step 4: 自動生成バインディングを理解する

Python側のgen_array_opsモジュールがC++定義から自動生成される仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | gen_array_ops.py | `tensorflow/python/ops/gen_array_ops.py` | 自動生成されたPythonバインディング（ビルド時生成） |

**読解のコツ**: gen_array_ops.pyはビルドプロセスで自動生成されるため、ソースツリーには直接存在しない。array_ops.pyの冒頭で `from tensorflow.python.ops.gen_array_ops import *` によりすべてのop関数がインポートされる（47行目）。

### プログラム呼び出し階層図

```
tf.reshape() [array_ops.py:65]
    |
    +-- dispatch.add_dispatch_support [デコレータ]
    |       +-- カスタムdispatch実装の呼び出し（存在する場合）
    |
    +-- d_api.call_with_layout [DTensor対応]
    |
    +-- gen_array_ops.reshape() [自動生成バインディング]
            |
            +-- C++ Reshape kernel
                    |
                    +-- shape_inference::UnchangedElementsShapeFn
```

### データフロー図

```
[入力]                    [処理]                        [出力]

Python Tensor     -->  array_ops.py                -->  結果 Tensor
(shape, dtype,         (入力検証・変換)
 value)                     |
                    gen_array_ops.py
                    (C++バインディング)
                            |
                    array_ops.cc
                    (Shape Inference)
                            |
                    C++ Kernel
                    (CPU/GPU実行)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| array_ops.py | `tensorflow/python/ops/array_ops.py` | ソース | Python API公開関数群 |
| array_ops.cc | `tensorflow/core/ops/array_ops.cc` | ソース | C++オペレーション定義・形状推論 |
| gen_array_ops.py | `tensorflow/python/ops/gen_array_ops.py` | 自動生成 | C++からの自動生成Pythonバインディング |
| array_ops_stack.py | `tensorflow/python/ops/array_ops_stack.py` | ソース | stack/unstack操作の実装 |
| tensor.py | `tensorflow/python/framework/tensor.py` | ソース | Tensorクラス定義 |
| tensor_shape.py | `tensorflow/python/framework/tensor_shape.py` | ソース | TensorShapeクラス定義 |
| dtypes.py | `tensorflow/python/framework/dtypes.py` | ソース | データ型定義 |
| constant_op.py | `tensorflow/python/framework/constant_op.py` | ソース | 定数テンソル生成 |
| ops.py | `tensorflow/python/framework/ops.py` | ソース | 計算グラフ操作の基盤 |
| shape_util.py | `tensorflow/python/ops/shape_util.py` | ソース | 形状ユーティリティ |
